Scriptname zBFSIceCritical extends activemagiceffect  

Spell property BFSDeadSpell auto
Spell property BFSDeadMagicSpell auto
Spell property BFSDeadShaderSpell auto

EffectShader property BlankShader auto
EffectShader property IceEffectShader auto
EffectShader property FreezeTexture auto
EffectShader property FreezeTextureInstant auto
EffectShader property IceWispsFX auto

actor target
bool bShader = false

EVENT OnEffectStart(Actor akTarget, Actor akCaster)
	target = akTarget
endEvent


EVENT OnEffectFinish(Actor akTarget, Actor akCaster)
	if target.IsDead()
		if !target.HasSpell(BFSDeadShaderSpell)
			target.AddSpell(BFSDeadSpell, false)
			target.AddSpell(BFSDeadShaderSpell, false)
			target.AddSpell(BFSDeadMagicSpell, false)
			IceEffectShader.play(target)
			BlankShader.play(target)	;;; This will remove any shader to allow the skin shader to be applied without problems
			FreezeTexture.play(target)
			bShader = true
		endif
	endif

	if bShader == true
		FreezeTextureInstant.play(target)
	endif
endEvent